#ifdef WIN32
//#include "csfunified/services/interface/MeetingServiceFeatureSetTypes.h"

#include "DesktopSharingControllerImplWin.h"
#include "csf/logger/CSFLogger.hpp"
#include "boost/bind.hpp"
#include "boost/function.hpp"

#include "jcfcoreutils/StringUtils.h"
#include "csfunified/services/interface/SystemService.h"
#include "csfunified/services/interface/ConfigService.h"
#include "csfunified/services/interface/ConfigValue.h"
#include "csfunified/services/interface/Presence.h"
#include "csfunified/services/interface/PresenceService.h"
#include "csfunified/services/interface/PresenceServiceCapabilities.h"
#include "csfsystemmonitor/SystemMonitor.h"
#include "csfsystemmonitor/SystemMonitorFactory.h"
#include "csfunified/framework/ServicesDispatcher.h"
#include "csfunified/framework/FunctorTask.h"
#include "jcfcoreutils/FunctionTask.h"

#include "featuresets/adapters/Dependence.h"

const std::wstring WebEx_DS_Url = L"WebEx_DS_Url";
const std::wstring WebEx_DS_Token = L"WebEx_DS_Token";

namespace CSFUnified {
    
    static CSFLogger* DesktopSharingControllerImplLogger = CSFLogger_getLogger("MeetingService-DesktopSharingControllerImpl");
    
    DesktopSharingControllerImpl::DesktopSharingControllerImpl(SMART_PTR_NS::shared_ptr<UnifiedFactory> unifiedFactory)
    : DesktopSharingControllerBaseImpl(unifiedFactory)
    {
        CSFLogDebugS(DesktopSharingControllerImplLogger, "DesktopSharingControllerImpl::DesktopSharingControllerImpl()");
        
        m_unifiedFactory = unifiedFactory;
        m_started = false;
        m_strSessionName = "";
        m_pDSMgr = NULL;
        
		m_pInstance = JM_SDK_WRAP::JabberSDKWrapImpl::getInstance();
        if (m_pInstance != NULL)
        {
			m_pDSMgr = m_pInstance->getIDSMgr();
        }

		m_pJabberServiceProvider = &JabberServiceProvider::getInstance();
    }
    
    DesktopSharingControllerImpl::~DesktopSharingControllerImpl()
    {
        m_strSessionName = "";
        m_started = false;

		DelPresenceNotifierConnection();

		if (m_ptrDSTokenChanged.lock() != NULL)
		{
			if (m_ptrDSTokenChanged.lock()->connected())
			{
				m_ptrDSTokenChanged.lock()->disconnect();
			}
		}
    }
     
	DesktopSharingControllerImpl * DesktopSharingControllerImpl::getInstance()
	{
		static DesktopSharingControllerImpl * m_dsController = NULL;
		if (NULL == m_dsController)
		{
			m_dsController = new DesktopSharingControllerImpl(JabberServiceProvider::getInstance().getUnifiedFactory());
		}

		return m_dsController;
	}

    // Feature set methods
    void DesktopSharingControllerImpl::registerDSCallback(SMART_PTR_NS::shared_ptr<DSCallback> dsCallback)
    {
        CSFLogDebugS(DesktopSharingControllerImplLogger, "DesktopSharingControllerImpl::registerDSCallback()");
		m_dsCallback = dsCallback.get();
    }
    
    void DesktopSharingControllerImpl::unregisterDSCallback(SMART_PTR_NS::shared_ptr<DSCallback> dsCallback)
    {
        CSFLogDebugS(DesktopSharingControllerImplLogger, "DesktopSharingControllerImpl::unregisterDSCallback()");
        m_dsCallback = NULL;
    }
    
    bool DesktopSharingControllerImpl::isInSharing()
    {
        CSFLogDebugS(DesktopSharingControllerImplLogger, "DesktopSharingControllerImpl::isInSharing()");
        if (m_pDSMgr != NULL)
        {
			return m_pDSMgr->IsInsharing() ? true : false;
        }
        return false;
    }
    
    bool DesktopSharingControllerImpl::canStartSharing(std::string sessionName)
    {
        CSFLogDebugS(DesktopSharingControllerImplLogger, "DesktopSharingControllerImpl::canStartSharing()");
        if (m_started && m_pDSMgr != NULL)
        {
			return m_pDSMgr->CanStartSharing(JCFCoreUtils::toWideString(sessionName)) ? true : false;
        }
        return false;
    }
    
    bool DesktopSharingControllerImpl::startSharing(std::string sessionName)
    {
        CSFLogDebugS(DesktopSharingControllerImplLogger, "DesktopSharingControllerImpl::startSharing()");
        if (m_pDSMgr != NULL)
        {
            CSFLogDebugS(DesktopSharingControllerImplLogger, "DesktopSharingControllerImpl::startSharing, session name = " << sessionName.c_str());

			return m_pDSMgr->Start(JCFCoreUtils::toWideString(sessionName)) ? true : false;
        }
        return false;
    }
    
    bool DesktopSharingControllerImpl::canJoinSharing(std::string sessionName)
    {
        CSFLogDebugS(DesktopSharingControllerImplLogger, "DesktopSharingControllerImpl::canJoinSharing()");
        if (m_started && m_pDSMgr != NULL)
        {
			int eType;
			return m_pDSMgr->CanJoinSharing(JCFCoreUtils::toWideString(sessionName), eType) ? true : false;
        }
        return false;
    }
    
    bool DesktopSharingControllerImpl::joinSharing(std::string sessionName)
    {
        CSFLogDebugS(DesktopSharingControllerImplLogger, "DesktopSharingControllerImpl::joinSharing()");
        if (m_pDSMgr != NULL)
        {
			return m_pDSMgr->Join(JCFCoreUtils::toWideString(sessionName)) ? true : false;
        }
        return false;
    }
    
    bool DesktopSharingControllerImpl::stopSharing()
    {
        CSFLogDebugS(DesktopSharingControllerImplLogger, "DesktopSharingControllerImpl::stopSharing()");
        if (m_pDSMgr != NULL)
        {
			return m_pDSMgr->StopCurSession() ? true : false;
        }
        return false;
    }
    
    bool DesktopSharingControllerImpl::reInviteCurSession()
    {
        CSFLogDebugS(DesktopSharingControllerImplLogger, "DesktopSharingControllerImpl::inviteUser2DS()");
        if (m_pDSMgr != NULL)
        {
			return m_pDSMgr->ReInviteCurSession() ? true : false;
        }
        return false;
    }
    
    bool DesktopSharingControllerImpl::restartSharing()
    {
        CSFLogDebugS(DesktopSharingControllerImplLogger, "DesktopSharingControllerImpl::restartSharing()");
        if (m_pDSMgr != NULL)
        {
			return m_pDSMgr->ReSharing() ? true : false;
        }
        return false;
    }
    
    bool DesktopSharingControllerImpl::changePresenter()
    {
        CSFLogDebugS(DesktopSharingControllerImplLogger, "DesktopSharingControllerImpl::changePresenter()");
        if (m_pDSMgr != NULL)
        {
			return m_pDSMgr->ChangePresenter() ? true : false;
        }
        return false;
    }
    
    bool DesktopSharingControllerImpl::cancelSharing()
    {
		CSFLogDebugS(DesktopSharingControllerImplLogger, "DesktopSharingControllerImpl::CancelStartSharing()");
		if (NULL != m_pDSMgr)
		{
			return m_pDSMgr->CancelStartSharing() ? true : false;
		}
		return false;
    }
    
    bool DesktopSharingControllerImpl::declineSharing(std::string sessionName)
    {
        CSFLogDebugS(DesktopSharingControllerImplLogger, "DesktopSharingControllerImpl::declineSharing()");

		DelPresenceNotifierConnection();
        if (m_pDSMgr != NULL)
        {
			return m_pDSMgr->Decline(JCFCoreUtils::toWideString(sessionName)) ? true : false;
        }
        return false;
    }

    // IDSEvent
	void DesktopSharingControllerImpl::OnStartingDialogShow(bool bShow)
	{
		CSFLogDebugS(DesktopSharingControllerImplLogger, "DesktopSharingControllerImpl::OnStartingDialogShow()");

		SMART_PTR_NS::shared_ptr<ServicesDispatcher> pServiceDispatcher = m_unifiedFactory->getServicesDispatcher();
		if (pServiceDispatcher != NULL && m_dsCallback != NULL)
		{
			bool bOnDispatcher = pServiceDispatcher->checkForUpdateAccess();
			if (bOnDispatcher)
			{
				m_dsCallback->onShowStartingDialog(bShow);
			}
			else
			{
				pServiceDispatcher->enqueueBlock(boost::bind(&DSCallback::onShowStartingDialog, m_dsCallback, bShow), "DesktopSharingControllerImpl::OnStartingDialogShow");
			}
		}
	}

	void DesktopSharingControllerImpl::OnNotifyUIUpdate()
	{
		CSFLogDebugS(DesktopSharingControllerImplLogger, "DesktopSharingControllerImpl::OnNotifyUIUpdate()");
		
		SMART_PTR_NS::shared_ptr<ServicesDispatcher> pServiceDispatcher = m_unifiedFactory->getServicesDispatcher();
		if (pServiceDispatcher != NULL && m_dsCallback != NULL)
		{
			bool bOnDispatcher = pServiceDispatcher->checkForUpdateAccess();
			if (bOnDispatcher)
			{
				m_dsCallback->onNotifyUIUpdate();
			}
			else
			{
				pServiceDispatcher->enqueueBlock(boost::bind(&DSCallback::onNotifyUIUpdate, m_dsCallback), "DesktopSharingControllerImpl::OnNotifyUIUpdate");
			}
		}
	}

	void DesktopSharingControllerImpl::OnSessionStarted(const wstring& strSessionName)
	{
		CSFLogDebugS(DesktopSharingControllerImplLogger, "DesktopSharingControllerImpl::OnSessionStarted()");

		std::string sessionName = JCFCoreUtils::toString(strSessionName);
		m_strSessionName = sessionName;

		AddPresenceNotifierConnection(sessionName);

		SMART_PTR_NS::shared_ptr<ServicesDispatcher> pServiceDispatcher = m_unifiedFactory->getServicesDispatcher();
		if (pServiceDispatcher != NULL && m_dsCallback != NULL)
		{
			bool bOnDispatcher = pServiceDispatcher->checkForUpdateAccess();
			if (bOnDispatcher)
			{
				m_dsCallback->onDSStarted(sessionName.c_str());
			}
			else
			{
				pServiceDispatcher->enqueueBlock(boost::bind(&DSCallback::onDSStarted, m_dsCallback, sessionName.c_str()), "DesktopSharingControllerImpl::OnSessionStarted");
			}
		}
	}

	void DesktopSharingControllerImpl::OnSessionEnded()
	{
		CSFLogDebugS(DesktopSharingControllerImplLogger, "DesktopSharingControllerImpl::OnSessionEnded()");

		DelPresenceNotifierConnection();

		SMART_PTR_NS::shared_ptr<ServicesDispatcher> pServiceDispatcher = m_unifiedFactory->getServicesDispatcher();
		if (pServiceDispatcher != NULL && m_dsCallback != NULL)
		{
			bool bOnDispatcher = pServiceDispatcher->checkForUpdateAccess();
			if (bOnDispatcher)
			{
				m_dsCallback->onDSEnded(m_strSessionName.c_str());
			}
			else
			{
				pServiceDispatcher->enqueueBlock(boost::bind(&DSCallback::onDSEnded, m_dsCallback, m_strSessionName.c_str()), "DesktopSharingControllerImpl::onDSEnded");
			}
		}
	}

	void DesktopSharingControllerImpl::OnSessionFailed(INT eType)
	{
		CSFLogDebugS(DesktopSharingControllerImplLogger, "DesktopSharingControllerImpl::OnSessionFailed()");

		DelPresenceNotifierConnection();

		SMART_PTR_NS::shared_ptr<ServicesDispatcher> pServiceDispatcher = m_unifiedFactory->getServicesDispatcher();
		if (pServiceDispatcher != NULL && m_dsCallback != NULL)
		{
			bool bOnDispatcher = pServiceDispatcher->checkForUpdateAccess();
			if (bOnDispatcher)
			{
				m_dsCallback->onDSError(m_strSessionName.c_str(), eType);
			}
			else
			{
				pServiceDispatcher->enqueueBlock(boost::bind(&DSCallback::onDSError, m_dsCallback, m_strSessionName.c_str(), eType), "DesktopSharingControllerImpl::onDSError");
			}
		}
	}

	void DesktopSharingControllerImpl::OnSessionStopped()
	{
		CSFLogDebugS(DesktopSharingControllerImplLogger, "DesktopSharingControllerImpl::OnSessionStopped()");

		DelPresenceNotifierConnection();

		SMART_PTR_NS::shared_ptr<ServicesDispatcher> pServiceDispatcher = m_unifiedFactory->getServicesDispatcher();
		if (pServiceDispatcher != NULL && m_dsCallback != NULL)
		{
			bool bOnDispatcher = pServiceDispatcher->checkForUpdateAccess();
			if (bOnDispatcher)
			{
				m_dsCallback->onSharingStopped(m_strSessionName.c_str());
			}
			else
			{
				pServiceDispatcher->enqueueBlock(boost::bind(&DSCallback::onSharingStopped, m_dsCallback, m_strSessionName.c_str()), "DesktopSharingControllerImpl::onSharingStopped");
			}
		}
	}

	void DesktopSharingControllerImpl::OnRecvSessionInvitation(const wstring& strSessionName)
	{
		std::string sessionName = JCFCoreUtils::toString(strSessionName);

		AddPresenceNotifierConnection(sessionName);

		SMART_PTR_NS::shared_ptr<ServicesDispatcher> pServiceDispatcher = m_unifiedFactory->getServicesDispatcher();
		if (pServiceDispatcher != NULL && m_dsCallback != NULL)
		{
			bool bOnDispatcher = pServiceDispatcher->checkForUpdateAccess();
			if (bOnDispatcher)
			{
				m_dsCallback->onDSInvitationReceived(sessionName.c_str());
			}
			else
			{
				pServiceDispatcher->enqueueBlock(boost::bind(&DSCallback::onDSInvitationReceived, m_dsCallback, sessionName.c_str()), "DesktopSharingControllerImpl::onDSInvitation");
			}
		}
	}

	void DesktopSharingControllerImpl::OnDeclineInvitation(const wstring& strSessionName)
	{
		CSFLogDebugS(DesktopSharingControllerImplLogger, "DesktopSharingControllerImpl::OnDeclineInvitation()");
		
		std::string sessionName = JCFCoreUtils::toString(strSessionName);

		SMART_PTR_NS::shared_ptr<ServicesDispatcher> pServiceDispatcher = m_unifiedFactory->getServicesDispatcher();
		if (pServiceDispatcher != NULL && m_dsCallback != NULL)
		{
			bool bOnDispatcher = pServiceDispatcher->checkForUpdateAccess();
			if (bOnDispatcher)
			{
				m_dsCallback->onDSDeclined(sessionName.c_str());
			}
			else
			{
				pServiceDispatcher->enqueueBlock(boost::bind(&DSCallback::onDSDeclined, m_dsCallback, sessionName.c_str()), "DesktopSharingControllerImpl::onDSDeclined");
			}
		}
	}

	void DesktopSharingControllerImpl::OnRequestOpenChat()
	{
		CSFLogDebugS(DesktopSharingControllerImplLogger, "DesktopSharingControllerImpl::OnRequestOpenChat()");

		SMART_PTR_NS::shared_ptr<ServicesDispatcher> pServiceDispatcher = m_unifiedFactory->getServicesDispatcher();
		if (pServiceDispatcher != NULL && m_dsCallback != NULL)
		{
			bool bOnDispatcher = pServiceDispatcher->checkForUpdateAccess();
			if (bOnDispatcher)
			{
				m_dsCallback->onRequestRestoreWindow();
			}
			else
			{
				pServiceDispatcher->enqueueBlock(boost::bind(&DSCallback::onRequestRestoreWindow, m_dsCallback), "DesktopSharingControllerImpl::onPopupChatWindow");
			}
		}
	}

	void DesktopSharingControllerImpl::OnRequestMinimizeChat()
	{
		CSFLogDebugS(DesktopSharingControllerImplLogger, "DesktopSharingControllerImpl::OnRequestMinimizeChat()");

		SMART_PTR_NS::shared_ptr<ServicesDispatcher> pServiceDispatcher = m_unifiedFactory->getServicesDispatcher();
		if (pServiceDispatcher != NULL && m_dsCallback != NULL)
		{
			bool bOnDispatcher = pServiceDispatcher->checkForUpdateAccess();
			if (bOnDispatcher)
			{
				m_dsCallback->onRequestMinimizeWindow();
			}
			else
			{
				pServiceDispatcher->enqueueBlock(boost::bind(&DSCallback::onRequestMinimizeWindow, m_dsCallback), "DesktopSharingControllerImpl::onMinimizeChatWindow");
			}
		}
	}

	void DesktopSharingControllerImpl::OnUserJoined()
	{
		CSFLogDebugS(DesktopSharingControllerImplLogger, "DesktopSharingControllerImpl::OnUserJoined()");

		SMART_PTR_NS::shared_ptr<ServicesDispatcher> pServiceDispatcher = m_unifiedFactory->getServicesDispatcher();
		if (pServiceDispatcher != NULL && m_dsCallback != NULL)
		{
			bool bOnDispatcher = pServiceDispatcher->checkForUpdateAccess();
			if (bOnDispatcher)
			{
				m_dsCallback->onUserJoined();
			}
			else
			{
				pServiceDispatcher->enqueueBlock(boost::bind(&DSCallback::onUserJoined, m_dsCallback), "DesktopSharingControllerImpl::onBuddyJoined");
			}
		}
	}

	void DesktopSharingControllerImpl::OnUserTryLeave(BOOL bHost)
	{
		CSFLogDebugS(DesktopSharingControllerImplLogger, "DesktopSharingControllerImpl::OnUserTryLeave()");

		SMART_PTR_NS::shared_ptr<ServicesDispatcher> pServiceDispatcher = m_unifiedFactory->getServicesDispatcher();
		if (pServiceDispatcher != NULL && m_dsCallback != NULL)
		{
			bool bOnDispatcher = pServiceDispatcher->checkForUpdateAccess();
			if (bOnDispatcher)
			{
				m_dsCallback->onUserTryLeave(bHost ? true : false);
			}
			else
			{
				pServiceDispatcher->enqueueBlock(boost::bind(&DSCallback::onUserTryLeave, m_dsCallback, bHost ? true : false),
					"DesktopSharingControllerImpl::onUserTryLeave");
			}
		}
	}

	void DesktopSharingControllerImpl::OnUserLeft()
	{
		CSFLogDebugS(DesktopSharingControllerImplLogger, "DesktopSharingControllerImpl::OnUserLeft()");

		SMART_PTR_NS::shared_ptr<ServicesDispatcher> pServiceDispatcher = m_unifiedFactory->getServicesDispatcher();
		if (pServiceDispatcher != NULL && m_dsCallback != NULL)
		{
			bool bOnDispatcher = pServiceDispatcher->checkForUpdateAccess();
			if (bOnDispatcher)
			{
				m_dsCallback->onUserLeft();
			}
			else
			{
				pServiceDispatcher->enqueueBlock(boost::bind(&DSCallback::onUserLeft, m_dsCallback), "DesktopSharingControllerImpl::onUserLeft");
			}
		}
	}

	void DesktopSharingControllerImpl::OnCleanSession(const wstring strSessionName)
	{
		CSFLogDebugS(DesktopSharingControllerImplLogger, "DesktopSharingControllerImpl::OnCleanSession()");
		
		std::string sessionName = JCFCoreUtils::toString(strSessionName);

		SMART_PTR_NS::shared_ptr<ServicesDispatcher> pServiceDispatcher = m_unifiedFactory->getServicesDispatcher();
		if (pServiceDispatcher != NULL && m_dsCallback != NULL)
		{
			bool bOnDispatcher = pServiceDispatcher->checkForUpdateAccess();
			if (bOnDispatcher)
			{
				m_dsCallback->onCleanSession(sessionName.c_str());
			}
			else
			{
				pServiceDispatcher->enqueueBlock(boost::bind(&DSCallback::onCleanSession, m_dsCallback, sessionName.c_str()), "DesktopSharingControllerImpl::onCleanSession");
			}
		}
	}

	void DesktopSharingControllerImpl::OnCleanUp()
	{
		
	}

	void DesktopSharingControllerImpl::OnErrorMsg(const wstring& strSessionName, INT eType)
	{
		CSFLogDebugS(DesktopSharingControllerImplLogger, "DesktopSharingControllerImpl::OnErrorMsg()");

		std::string sessionName = JCFCoreUtils::toString(strSessionName);

		SMART_PTR_NS::shared_ptr<ServicesDispatcher> pServiceDispatcher = m_unifiedFactory->getServicesDispatcher();
		if (pServiceDispatcher != NULL && m_dsCallback != NULL)
		{
			bool bOnDispatcher = pServiceDispatcher->checkForUpdateAccess();
			if (bOnDispatcher)
			{
				m_dsCallback->onErrorMsg(sessionName, eType);
			}
			else
			{
				pServiceDispatcher->enqueueBlock(boost::bind(&DSCallback::onErrorMsg, m_dsCallback, sessionName, eType), "DesktopSharingControllerImpl::onErrorMsg");
			}
		}
	}

	void DesktopSharingControllerImpl::OnPresenterDidChange()
	{
		CSFLogDebugS(DesktopSharingControllerImplLogger, "DesktopSharingControllerImpl::OnPresenterDidChange()");

		SMART_PTR_NS::shared_ptr<ServicesDispatcher> pServiceDispatcher = m_unifiedFactory->getServicesDispatcher();
		if (pServiceDispatcher != NULL && m_dsCallback != NULL)
		{
			bool bOnDispatcher = pServiceDispatcher->checkForUpdateAccess();
			if (bOnDispatcher)
			{
				m_dsCallback->onPresenterChanged();
			}
			else
			{
				pServiceDispatcher->enqueueBlock(boost::bind(&DSCallback::onPresenterChanged, m_dsCallback), "DesktopSharingControllerImpl::OnPresenterDidChange");
			}
		}
	}

	std::string DesktopSharingControllerImpl::GetDSToken()
	{
		CSFLogInfoS(DesktopSharingControllerImplLogger, "DesktopSharingControllerImpl::GetDSToken.");
		if (NULL == m_unifiedFactory)
		{
			CSFLogInfoS(DesktopSharingControllerImplLogger, "DesktopSharingControllerImpl::GetDSToken.  m_unifiedFactory == NULL");
			return "";
		}

		SMART_PTR_NS::shared_ptr<PresenceService> ptrDSTokenPS = m_unifiedFactory->getService<PresenceService>();
		if (NULL == ptrDSTokenPS)
		{
			CSFLogInfoS(DesktopSharingControllerImplLogger, "DesktopSharingControllerImpl::GetDSToken Can not get PresenceService.");
			return "";
		}

		SMART_PTR_NS::shared_ptr<PresenceServiceNotifiers> ptrPSNotifiers = ptrDSTokenPS->getPresenceServiceNotifiers();
		if (NULL == ptrPSNotifiers)
		{
			CSFLogInfoS(DesktopSharingControllerImplLogger, "DesktopSharingControllerImpl::GetDSToken Can not get PresenceServiceNotifiers.");
			return "";
		}

		SMART_PTR_NS::shared_ptr<PropertyNotifier>	ptrDSTokenPropertyNotifier = ptrPSNotifiers->getDesktopShareTokenNotifier();
		if (NULL == ptrDSTokenPropertyNotifier)
		{
			CSFLogInfoS(DesktopSharingControllerImplLogger, "DesktopSharingControllerImpl::GetDSToken Can not get PropertyNotifier.");
			return "";
		}

		m_ptrDSTokenChanged = ptrDSTokenPropertyNotifier->connect(boost::bind(&DesktopSharingControllerImpl::OnDSTokenValueChanged, this));

		ptrDSTokenPS->RenewDesktopShareToken();

		return "";
	}

	void DesktopSharingControllerImpl::OnDSTokenValueChanged()
	{
		CSFLogInfoS(DesktopSharingControllerImplLogger, "DesktopSharingControllerImpl::OnDSTokenValueChanged.");

		if (PropertyNotifierConnectionPtr l = m_ptrDSTokenChanged.lock())
		{
			if (l->connected())
			{
				l->disconnect();
			}
		}

		IJabberSDKWrap * pJMSDKWrap = CDependence::getInstance()->GetJabberSDKWrap();
		if (NULL == pJMSDKWrap)
		{
			CSFLogInfoS(DesktopSharingControllerImplLogger, "DesktopSharingControllerImpl::OnDSTokenValueChanged pJMDependence = NULL");
			return;
		}

		IJMCommonEventCallback * pEventCallback = pJMSDKWrap->getCommonEventCallback();
		if (NULL == pEventCallback)
		{
			CSFLogInfoS(DesktopSharingControllerImplLogger, "DesktopSharingControllerImpl::OnDSTokenValueChanged pEventCallback = NULL");
			return;
		}

		std::wstring strToken = L"";

		SMART_PTR_NS::shared_ptr<PresenceService> ptrDSTokenPS = m_unifiedFactory->getService<PresenceService>();
		if (NULL != ptrDSTokenPS)
		{
			std::string strDsToken = ptrDSTokenPS->getDesktopShareToken();
			if (strDsToken == "")
			{
				CSFLogInfoS(DesktopSharingControllerImplLogger, "DesktopSharingControllerImpl::OnDSTokenValueChanged Can not get DS_Token.");
			}
			else
			{
				CSFLogInfoS(DesktopSharingControllerImplLogger, "DesktopSharingControllerImpl::OnDSTokenValueChanged DS TOKEN = " << strDsToken.c_str());
				strToken = JCFCoreUtils::toWideString(strDsToken);
			}
		}

		std::string strUrl = m_pJabberServiceProvider->getDSURL();
		pEventCallback->OnDSParamReady(JCFCoreUtils::toWideString(strUrl), strToken);
	}

    //
    void DesktopSharingControllerImpl::start()
    {
        CSFLogDebugS(DesktopSharingControllerImplLogger, "DesktopSharingControllerImpl::start()");
		CDependence::getInstance()->start();
		m_pDSMgr = CDependence::getInstance()->getpDesktopSharingHandle();
		if (NULL != m_pDSMgr)
		{
			JM_SDK_WRAP::JabberSDKWrapImpl::getInstance()->setIDSMgrEvent(this);
		}
        
        m_started = true;
    }
    
    void DesktopSharingControllerImpl::stop()
    {
        CSFLogDebugS(DesktopSharingControllerImplLogger, "DesktopSharingControllerImpl::stop()");
		if (NULL != m_pDSMgr)
		{
			JM_SDK_WRAP::JabberSDKWrapImpl::getInstance()->setIDSMgrEvent(NULL);
			m_pDSMgr->StopCurSession();
			m_pDSMgr = NULL;
		}
		CDependence::getInstance()->stop();
        
        m_started = false;
    }
    
	void DesktopSharingControllerImpl::OnSenderPresenceChanged(std::string senderName)
	{
		CSFLogDebugS(DesktopSharingControllerImplLogger, "DesktopSharingMgrAdapter::OnPresenterDidChange()");

		bool isOnDispatcher = m_unifiedFactory->getServicesDispatcher()->checkForUpdateAccess();
		if (isOnDispatcher)
		{
			if (!CDependence::getInstance()->GetJabberWerxCommonHelper()->IsBuddyOnline(JCFCoreUtils::toWideString(senderName)))
			{
				//callback->OnCleanSession(JCFCoreUtils::toString(strSessionName.c_str()));
				/*wstring AccountName = CDependence::getInstance()->GetJabberWerxCommonHelper()->GetMyAccountName();
				wstring IMCmd = L"";
				CDependence::getInstance()->GetIMCallback()->OnRecv_DSCancelled(AccountName, strSessionName, IMCmd);*/
				CSFLogDebugS(DesktopSharingControllerImplLogger, "DesktopSharingMgrAdapter::Fire_OnSenderPreseceChanged()  Call OnUserSignOff");
				if (CDependence::getInstance()->GetJabberSDKWrap() != NULL && CDependence::getInstance()->GetJabberSDKWrap()->getCommonEventCallback() != NULL)
				{
					CDependence::getInstance()->GetJabberSDKWrap()->getCommonEventCallback()->OnUserSignOff(JCFCoreUtils::toWideString(senderName));
				}
				DelPresenceNotifierConnection();
			}
		}
		else
		{
			csf::TaskPtr task(new JCFCoreUtils::FunctionTask(
				std::bind(&DesktopSharingControllerImpl::OnSenderPresenceChanged, this, senderName),
				"DesktopSharingControllerImpl::OnSenderPresenceChanged"));
			m_unifiedFactory->getServicesDispatcher()->enqueueBlock(task);
		}
	}

	void DesktopSharingControllerImpl::AddPresenceNotifierConnection(std::string senderName)
	{
		CSFLogDebugS(DesktopSharingControllerImplLogger, "DesktopSharingControllerImpl::AddNotifierConnection()");
		
		DelPresenceNotifierConnection();

		SMART_PTR_NS::shared_ptr<Contact> contact = m_pJabberServiceProvider->getContact(senderName);
		if (contact.get() == NULL)
		{
			return;
		}

		m_pSenderPresenceChange = contact->getPresence()->getPresenceNotifiers()->getStateNotifier()->connect(boost::bind(&DesktopSharingControllerImpl::OnSenderPresenceChanged, this, senderName));
	}

	void DesktopSharingControllerImpl::DelPresenceNotifierConnection()
	{
		CSFLogDebugS(DesktopSharingControllerImplLogger, "DesktopSharingControllerImpl::DelNotifierConnection()");

		if (m_pSenderPresenceChange.lock() != NULL)
		{
			if (m_pSenderPresenceChange.lock()->connected())
			{
				m_pSenderPresenceChange.lock()->disconnect();
			}
		}

	}
}
#endif